<?php
session_start();
include("../../func/db.php");

// AJAX isteklerini işle
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $response = ['success' => false, 'message' => ''];
    
    if (isset($_POST['start_process']) && isset($_POST['xml_id'])) {
        $xml_id = intval($_POST['xml_id']);
        
        // XML ayarlarını getir
        $xml_config = $ozy->query("SELECT * FROM xml WHERE id = $xml_id")->fetch(PDO::FETCH_ASSOC);
        
        if (!$xml_config) {
            $response['message'] = 'XML konfigürasyonu bulunamadı';
            echo json_encode($response);
            exit;
        }
        
        // Lock dosyası kontrol et
        $lockFile = 'xml_process.lock';
        if (file_exists($lockFile)) {
            $lockTime = filemtime($lockFile);
            $timeDiff = time() - $lockTime;
            if ($timeDiff < 3600) { // 1 saat içinde işlem varsa
                $response['message'] = 'XML işlemi zaten devam ediyor';
                echo json_encode($response);
                exit;
            } else {
                unlink($lockFile); // Eski lock dosyasını temizle
            }
        }
        
        // Progress dosyasını başlat
        file_put_contents('xml_progress.txt', '0|XML işlemi başlatılıyor...');
        
        // Lock dosyası oluştur
        file_put_contents($lockFile, time() . '|' . $xml_id);
        
        // Arkaplanda XML işlemini başlat
        if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
            // Windows için
            $cmd = 'start /B php "' . __DIR__ . '/xml_process_worker.php" ' . $xml_id . ' > NUL 2>&1';
            pclose(popen($cmd, 'r'));
        } else {
            // Linux/Unix için
            $cmd = 'nohup php "' . __DIR__ . '/xml_process_worker.php" ' . $xml_id . ' > /dev/null 2>&1 &';
            exec($cmd);
        }
        
        $response['success'] = true;
        $response['message'] = 'XML işlemi arkaplanda başlatıldı';
        echo json_encode($response);
        exit;
    }
    
    // İşlem durumunu kontrol et
    if (isset($_POST['check_status'])) {
        $lockFile = 'xml_process.lock';
        $isProcessing = false;
        $xmlId = null;
        
        if (file_exists($lockFile)) {
            $lockData = file_get_contents($lockFile);
            $parts = explode('|', $lockData);
            $lockTime = intval($parts[0]);
            $xmlId = isset($parts[1]) ? intval($parts[1]) : null;
            
            $timeDiff = time() - $lockTime;
            if ($timeDiff < 3600) { // 1 saat içinde işlem varsa
                $isProcessing = true;
            }
        }
        
        // Progress bilgisini oku
        $progress = '0|Hazır';
        if (file_exists('xml_progress.txt')) {
            $progress = file_get_contents('xml_progress.txt');
        }
        
        $response['success'] = true;
        $response['data'] = [
            'is_processing' => $isProcessing,
            'xml_id' => $xmlId,
            'progress' => $progress
        ];
        echo json_encode($response);
        exit;
    }
}

// GET istekleri için basit status sayfası
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    ?>
    <!DOCTYPE html>
    <html>
    <head>
        <title>XML İşlem Durumu</title>
        <meta charset="utf-8">
        <style>
            body { font-family: Arial, sans-serif; padding: 20px; background: #f5f5f5; }
            .container { max-width: 600px; margin: 0 auto; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
            .status { padding: 15px; border-radius: 5px; margin: 20px 0; }
            .processing { background: #fff3cd; border: 1px solid #ffeaa7; color: #856404; }
            .idle { background: #d4edda; border: 1px solid #c3e6cb; color: #155724; }
            .progress-bar { width: 100%; height: 25px; background: #e9ecef; border-radius: 12px; overflow: hidden; margin: 10px 0; }
            .progress-fill { height: 100%; background: linear-gradient(90deg, #28a745, #20c997); transition: width 0.3s ease; }
            .btn { padding: 10px 20px; background: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; margin: 5px; }
            .btn:hover { background: #0056b3; }
            .btn:disabled { background: #6c757d; cursor: not-allowed; }
        </style>
    </head>
    <body>
        <div class="container">
            <h2>XML İşlem Durumu</h2>
            
            <div id="status-container">
                <div class="status idle">
                    <strong>Durum:</strong> <span id="status-text">Kontrol ediliyor...</span>
                </div>
                
                <div class="progress-bar">
                    <div class="progress-fill" id="progress-bar" style="width: 0%"></div>
                </div>
                
                <div id="progress-text">Hazırlanıyor...</div>
            </div>
            
            <div style="text-align: center; margin-top: 30px;">
                <button class="btn" onclick="location.reload()">Yenile</button>
                <button class="btn" onclick="window.close()">Kapat</button>
            </div>
        </div>

        <script>
        function updateStatus() {
            fetch('xml_process_backend.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: 'check_status=1'
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    const statusContainer = document.getElementById('status-container');
                    const statusText = document.getElementById('status-text');
                    const progressBar = document.getElementById('progress-bar');
                    const progressText = document.getElementById('progress-text');
                    
                    if (data.data.is_processing) {
                        statusContainer.querySelector('.status').className = 'status processing';
                        statusText.textContent = 'XML işlemi devam ediyor...';
                        
                        // Progress bilgisini işle
                        const progressParts = data.data.progress.split('|');
                        const progressValue = progressParts[0];
                        const progressMessage = progressParts[1] || 'İşleniyor...';
                        
                        progressText.textContent = progressMessage;
                        
                        if (progressValue === 'done') {
                            progressBar.style.width = '100%';
                            statusContainer.querySelector('.status').className = 'status idle';
                            statusText.textContent = 'İşlem tamamlandı!';
                            setTimeout(() => window.close(), 3000);
                        } else if (progressValue > 0) {
                            const percent = Math.min((progressValue / 10000) * 100, 100);
                            progressBar.style.width = percent + '%';
                        }
                    } else {
                        statusContainer.querySelector('.status').className = 'status idle';
                        statusText.textContent = 'Aktif işlem yok';
                        progressText.textContent = 'Hazır';
                        progressBar.style.width = '0%';
                    }
                }
            })
            .catch(error => {
                console.error('Status kontrolü hatası:', error);
            });
        }
        
        // Sayfa yüklendiğinde ve her 2 saniyede bir güncelle
        updateStatus();
        setInterval(updateStatus, 2000);
        </script>
    </body>
    </html>
    <?php
    exit;
}
?>
