<?php
$year = date("Y"); 
$domain = $_SERVER['SERVER_NAME']; 
$user_info = posix_getpwuid(posix_geteuid());
$cpanel_user = $user_info['name'];  

$path_normal = "/home/{$cpanel_user}/tmp/awstats/";
$path_ssl    = "/home/{$cpanel_user}/tmp/awstats/ssl/";

$yearly_bandwidth = 0;
  
$paths = [$path_normal, $path_ssl];

foreach ($paths as $path) {
    for ($month = 1; $month <= 12; $month++) {
        $month_str = str_pad($month, 2, "0", STR_PAD_LEFT);
        $file = "{$path}awstats{$month_str}{$year}.{$domain}.txt";

        if (!file_exists($file)) continue;

        $content = file_get_contents($file);

        if (preg_match("/BEGIN_DAY(.*?)END_DAY/s", $content, $match)) {
            $lines = explode("\n", trim($match[1]));
            foreach ($lines as $line) {
                $line = trim($line);
                if (empty($line) || strpos($line, "#") === 0) continue;
 
                $parts = preg_split('/\s+/', $line);
                if (count($parts) >= 5) {
                    $yearly_bandwidth += (int)$parts[4];
                }
            }
        }
    }
}
  
function formatBytesGB($bytes, $precision = 2) {
    $bytes = max($bytes, 0);
    $bytes /= 1024; // KB → GB’ye gitmeden direkt GB hesap
    $bytes /= 1024; // KB → MB → GB
    $bytes /= 1024; // Byte → GB
    return round($bytes, $precision) . ' GB';
}
 
function Trafik() {
    global $yearly_bandwidth;
    return formatBytesGB($yearly_bandwidth);
}
 
?>
